Option Strict Off
Option Explicit On
Module adt8840
	Public axis_durum(4) As Integer
	Public g_durum, inp_durum, idle_durum, lock_durum As Integer
    

    Public Structure SYSPARA 'File system parameter structure
        <VBFixedArray(3)> Dim fHomeStartv() As Single 'Back to the origin of the initial rate
        <VBFixedArray(3)> Dim fHomeSpeed() As Single 'Back to the origin of the driving speed
        <VBFixedArray(3)> Dim fHomeAccTime() As Single 'Back to the origin of the acceleration time
        <VBFixedArray(3)> Dim fHomelSpeed() As Single 'Back to the origin search speed
        <VBFixedArray(3)> Dim fHomelRange() As Single 'Back to the origin Search
        <VBFixedArray(3)> Dim fStartv() As Single 'Initial speed of processing
        <VBFixedArray(3)> Dim fSpeed() As Single 'Processing speed drive
        <VBFixedArray(3)> Dim fAccTime() As Single 'Processing of acceleration time
        <VBFixedArray(3)> Dim lPulseMm() As Long 'Pulse equivalent
        <VBFixedArray(3)> Dim Home() As Byte 'Origin of the signal is valid
        <VBFixedArray(3)> Dim home_logic() As Byte 'Origin of the signal level
        <VBFixedArray(3)> Dim ucZi() As Byte 'Encoder Z-phase is valid
        <VBFixedArray(3)> Dim Zi_logic() As Byte 'Z-phase effective level
        <VBFixedArray(3)> Dim home_setup() As Byte 'The axis back to the implementation of conditions of origin
        <VBFixedArray(3)> Dim home_step() As Byte 'Back to the origin of each axis step value is (0-3)
        <VBFixedArray(3)> Dim limit_pos() As Byte 'Is the effective limit
        <VBFixedArray(3)> Dim limit_neg() As Byte 'Negative limit effective
        <VBFixedArray(3)> Dim limit_logic() As Byte 'Limit logic
        <VBFixedArray(3)> Dim pulse_mode() As Byte 'Pulse mode
        <VBFixedArray(3)> Dim pulse_logic() As Byte 'Pulse Logic
        <VBFixedArray(3)> Dim dir_logic() As Byte 'Direction signal logic
        <VBFixedArray(3)> Dim en_alarm() As Byte 'Servo alarm signal effectively
        <VBFixedArray(3)> Dim alarm_logic() As Byte 'Servo alarm signal logic
        Dim alarm_out As Integer 'Alarm output signal, the specified output points (0-21)
        Dim alarm_out_logic As Integer 'Alarm output signal logic
        Dim en_broadcast As Integer 'Broadcast messages when the netwo

        'UPGRADE_TODO: "Initialize" must be called to initialize instances of this structure. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="B4BFF9E0-8631-45CF-910E-62AB3970F27B"'
        Public Sub Initialize()
            ReDim fHomeStartv(3)
            ReDim fHomeSpeed(3)
            ReDim fHomeAccTime(3)
            ReDim fHomelSpeed(3)
            ReDim fHomelRange(3)
            ReDim fStartv(3)
            ReDim fSpeed(3)
            ReDim fAccTime(3)
            ReDim lPulseMm(3)
            ReDim Home(3)
            ReDim home_logic(3)
            ReDim ucZi(3)
            ReDim Zi_logic(3)
            ReDim home_setup(3)
            ReDim home_step(3)
            ReDim limit_pos(3)
            ReDim limit_neg(3)
            ReDim limit_logic(3)
            ReDim pulse_mode(3)
            ReDim pulse_logic(3)
            ReDim dir_logic(3)
            ReDim en_alarm(3)
            ReDim alarm_logic(3)
        End Sub
    End Structure
	
	'UPGRADE_WARNING: Arrays in structure sys_para may need to be initialized before they can be used. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="814DF224-76BD-4BB4-BFFB-EA359CB9FC48"'
    Public sys_para2 As SYSPARA
    Public devnum As Integer

    Declare Function adt8840a_download_sysfile Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal mode As Integer, ByRef sys_para As SYSPARA, ByVal file As String) As Integer
    'Function function: the system configuration parameters downloaded to the control card in the'
    'Parameters: dev_num device number
    ' mode to download mode, 0: only download to control the card but does not save a system file 1: Download to the control card into the system files while preserving
    'file system file name, if the input is an empty string indicates the default file
    ' syspara system parameters structure '
    ' Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
    Declare Function adt8840a_upload_sysfile Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal mode As Integer, ByVal file As String, ByRef sys_para As SYSPARA) As Integer
    'Functions Function: Loading system configuration file parameter'
    'Parameters: dev_num device number
    ' mode loading mode 0: load control card of the current operating parameters to the host 1: From the control card system files to load parameters to the host
    'file system file name, if the input is an empty string indicates the default file
    'syspara system parameters structure'
    'Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
    Declare Function adt8840a_go_home Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
    'Function function: back to the origin function'
    'Parameters: dev_num device number' home_para back to the origin parameter structure '
    ' Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface

	
	'//-------------------------------------------------//
	'//              Device interface, parameter type                 //
	'//-------------------------------------------------//
	Declare Sub DeviceAddr_init Lib "adt8840.dll" ()
	'Function features: Device Interface address initialization
	' Parameters: None
	'Returns: None
	
	
	'UPGRADE_NOTE: err was upgraded to err_Renamed. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Declare Function TCP_Conn Lib "adt8840.dll" (ByVal ip_addr As String, ByVal mac_addr As String, ByRef err_Renamed As Integer) As Integer
	'Function features: TCP network connection
	' parameter: 'ip_addr IP address' mac_addr card address
	' err for receiving the error code, 0: OK, 1: connection already exists, 2: beyond the maximum number of connections, 3: SOCKET error, 4: TCP connection failed
	'return values: device number
	
	Declare Sub Close_netconn Lib "adt8840.dll" (ByVal devnum As Integer)
	'Function features: TCP network closure
	' parameters:
	'dev_num device number
	' Return Value: None
	
	Declare Sub Close_all Lib "adt8840.dll" ()
	'Function function: Close all network connections and resources
	' parameters: None
	' Returns: None
	
	
	
	Declare Function Get_sock Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Function features: access to equipment under the equipment numbers of network communication socket (SOCKET)
	' Parameters:
	'dev_num device number
	' Return value: Returns non-zero SOCKET value, return -1 indicates the device number is invalid
	
	Declare Function Uart_show Lib "adt8840.dll" (ByVal devnum As Integer, ByVal on_off As Integer) As Integer
	'Function function: serial debug display switch
	' parameters:
	'devnum device number
	' on_off serial debug display switch, 1: Open the serial debug display, 0: close debugging serial port 1: Open the serial port debugging, display all the information, 2: Open the serial port debugging Showing some of the information
	'return values: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_set_pulse_mode Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal value As Integer, ByVal logic As Integer, ByVal dir_logic As Integer) As Integer
	'Functions Function: Set the output pulse of the working methods' parameter:
	'devnum device number
	' axis axis No. 1-4
	'value 0: pulse + pulse method, 1: Pulse + direction method
	' logic 0: positive logic pulse, 1: Negative logic pulse
	'dir_logic 0: the direction of the output signal is logic 1: the direction of the negative logic output signals
	' return values: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: Accept to the abnormal data, -4: Invalid Device Interface
	'default mode: Pulse + direction, positive logic pulse and direction output signals are logic
	
	
	Declare Function adt8840a_set_limit_mode Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal v1 As Integer, ByVal v2 As Integer, ByVal dir_logic As Integer) As Integer
	'Function: set the positive and negative direction limit input signal nLMT mode' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'v1 0: valid 1 is limit: Limit is invalid
	' v2 0: negative limit effective 1: Negative limit invalid
	'logic 0: active low 1: high effective' return values: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	'default mode is: is the effective limit the negative limit effective, low effective
	
	Declare Function adt8840a_set_stop0_mode Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
	'Function: Set stop0 input mode
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'v 0: valid 1: Effective
	' logic 0: active low 1: high effective
	'return Value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	'default mode: Invalid
	
	Declare Function adt8840a_set_stop1_mode Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal v As Integer, ByVal logic As Integer) As Integer
	'Function: Set stop1 input mode
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'v 0: valid 1: Effective
	' logic 0: active low 1: high effective
	'return Value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	'default mode: Invalid
	
	'//----------------------------------------------------//
	'//              Driver status check function                   //
	'//----------------------------------------------------//
	Declare Function adt8840a_get_status Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByRef value As Integer) As Integer
	'Function: get the axis of the drive status
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'v 0 drive status indicators: Drive end of the non-0: are drivers
	' return values: 0: execution OK, 1: fails, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_get_inp_status Lib "adt8840.dll" (ByVal devnum As Integer, ByRef value As Integer) As Integer
	'Function: get interpolation driving status
	' parameter:' devnum device number
	'v interpolation state pointer 0: interpolation end of the 1: is interpolation
	' return values: 0: execution OK, 1: Execution failed, -1: Send exception, -2: response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_get_int_status Lib "adt8840.dll" (ByVal devnum As Integer, ByRef value As Integer) As Integer
	'Function: get interrupt status
	' parameter:' devnum device number
	'v interpolation state pointer 0: interpolation end of the 1: is interpolation
	' return values: 0: execution OK, 1: Execution failed, -1: Send unusual, - 2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	'//----------------------------------------------------//
	'//              Movement parameter setting function                    //
	'//----------------------------------------------------//
	Declare Function adt8840a_set_acc Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal add As Integer) As Integer
	'Function: Acceleration setting
	' parameters: 'devnum device number
	' axis axis number (1 - 4)
	'Add range (1 - 32000) acceleration actual value add * 250
	' return values: 0: execution OK, 1: execution failed -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_set_startv Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal startv As Integer) As Integer
	'Function: the initial speed setting
	' parameters: 'devnum device number' axis axis number (1 - 4)
	'startv range (1-2M)
	' Return value: 0: execution OK, 1: Execution failed, -1: Send exception, -2: response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_set_speed Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal speed As Integer) As Integer
	'Function: Drive speed setting
	' parameters:
	'devnum device number
	' axis axis number (1 - 4)
	'speed range (1-2M)
	' Return value: 0: execution OK, 1: Execution failed, -1: Send unusual , -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_set_command_pos Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
	'Function: logical location to set
	' parameters: 'devnum device number
	' axis axis number (1 - 4)
	'value range (-2147483648 ~ +2147483647)' Return value: 0: execution OK, 1: Execution failed, -1: send exception, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_set_actual_pos Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
	'Function: Set the actual location
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'value range (-2147483648 ~ +2147483647)
	' Return value: 0: execution OK, 1: Execution failed, -1: send exception, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	'//----------------------------------------------------//
	'//               Check the function of motion parameters                    //
	'//----------------------------------------------------//
	Declare Function adt8840a_get_command_pos Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByRef value As Integer) As Integer
	'Function: get the axis of the logical location
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'value logical location of the pointer
	' Returns: 0: execution OK, 1: Execution failed, -1: Send unusual , -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_get_actual_pos Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByRef value As Integer) As Integer
	'Function: get the axis of the actual location of the
	' parameters:
	'devnum device number
	' axis axis number (1 - 4)
	'value the actual location of the pointer
	' Returns: 0: execution OK, 1: Execution failed, -1: Send unusual , -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_get_speed Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByRef value As Integer) As Integer
	'Function: get the axis of the current drive speed
	' parameter: 'devnum device number' axis axis number (1 - 4)
	'value-driven speed of the current pointer
	' Returns: 0: execution OK, 1: Execution failed, -1: send exception, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_all_command_pos Lib "adt8840.dll" (ByVal dev_num As Integer, ByRef LogPos As Integer) As Integer
	'Function features: access to the logical location of all four axes'
	' Parameters: dev_num Equipment No. '
	' Output parameters: pos [] to receive the logic of each axis position data, pos [0] axis 1 position, pos [1] axis 1 position, pos [2] axis 1 position, pos [3] axes a position '
	' Returns: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_all_actual_pos Lib "adt8840.dll" (ByVal dev_num As Integer, ByRef ActPos As Integer) As Integer
	'Function features: access to all four axes of the actual location of the'
	'Parameters: dev_num device number
	' pos [] to receive the shaft of the true position data, pos [0] axis 1 position, pos [1] axis 1 position, pos [2] axis 1 position, pos [3] axes a position '
	' Returns: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_all_speed Lib "adt8840.dll" (ByVal dev_num As Integer, ByRef speed As Integer) As Integer
	'Function features: access to all 4-axis driver speed'
	'Parameters: int dev_num Equipment No.
	' long pos [] to receive the drive shaft speed '
	' Returns: 0: execution OK, 1: Execution failed, -1: Send unusual , -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	
	
	'//----------------------------------------------------//
	'//                   Driving function                         //
	'//----------------------------------------------------//
	Declare Function adt8840a_pmove Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal value As Integer) As Integer
	'Function: Quantitative drivers' parameters:
	'devnum device number' axis axis number (1 - 4)
	'value output pulses (-268435455 ~ +268435455)> 0: positive direction driving <0: Negative direction drive
	' Return value: 0: Execute OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_pmove2 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal axis2 As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer) As Integer
	'Function features: 2-axis
	' parameter: int dev_num device number
	' int axis1 involved interpolation of axis No.
	'int axis2 involved interpolation of axis No.
	' long pulse1 axis1 move relative distance
	'long pulse2 axis2 move relative distance
	' return Value: 0: execution OK, -1: Send unusual, -4: Invalid Device Inter
	
	Declare Function adt8840a_pmove3 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal pulse3 As Integer) As Integer
	'Function features: 2-axis' parameter: int dev_num device number
	' int axis1 involved interpolation of axis No.
	'int axis2 involved interpolation of axis No.
	' int axis3 involved interpolation of axis No.
	'long pulse1 axis1 move relative distance
	' long pulse2 axis2 move relative distance
	'long pulse3 axis3 move relative distance
	' return values: 0: execution OK, -1: Send unusual, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_pmove4 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal pulse3 As Integer, ByVal pulse4 As Integer) As Integer
	'Function features: 2-axis' parameter: int dev_num Equipment No.
	'long pulse1 axis 1 to move relative distance
	' long pulse2 axis 2 to move relative distance
	'long pulse3 axis 3 to move relative distance
	' long pulse4 shaft 4 to move relative distance 'Returns: 0: execution OK, -1: Send unusual, -4: Invalid Device Interface
	
	'UPGRADE_NOTE: dir was upgraded to dir_Renamed. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Declare Function adt8840a_continue_move Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer, ByVal dir_Renamed As Integer) As Integer
	'Function: continuous drive
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'dir output direction, 0: positive direction, 1: reverse direction
	' return values: 0: execution OK, 1: execution failed -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_dec_stop Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer) As Integer
	'Function: Drive deceleration to stop
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'Return value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, - 3: receive abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_sudden_stop Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Integer) As Integer
	'Function: Drive to immediately stop
	' parameter: 'devnum device number
	' axis axis number (1 - 4)
	'Return value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, - 3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_stop_sel Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis As Byte, ByVal mode As Integer) As Integer
	'Function function: Selective stop the Axis'
	' Parameters: int dev_num device number
	'char axia [4] choose to stop the axis, 0 for the do not choose to stop, a stop for the selection of
	' int mode 0: deceleration to stop, 1: immediately Stop '
	' Returns: 0: execution OK, -1: Send unusual, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_stop_all Lib "adt8840.dll" (ByVal dev_num As Integer) As Integer
	'Functions Function: Emergency stop for all axes, and to abandon the current processing task
	' parameter: dev_num device number
	'return values: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_inp_move2 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer) As Integer
	'Function: 2-axis linear interpolation
	' parameters: 'devnum device number
	' axis1, axis2 involved interpolation of axis No.
	'pulse1, pulse2 moving relative distance (-8388608 ~ +8388607)
	' Return value: 0: execution OK, 1 : execution failed -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_inp_move3 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal pulse3 As Integer) As Integer
	'Function: Three-axis linear interpolation
	' parameters: 'devnum device number
	' axis1, axis2, axis3 involved interpolation of axis No.
	'pulse1, pulse2, pulse3 moving relative distance (-8,388,608 ~ +8388607)
	' Return value: 0: implementation of the OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_inp_move4 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal pulse3 As Integer, ByVal pulse4 As Integer) As Integer
	'Function: Four-axis linear interpolation
	' parameters: 'devnum device number
	' pulse1, pulse2, pulse3, pulse4 XYZA four-axis movement of the relative distance (-8,388,608 ~ +8388607)
	'Return value: 0: execution OK, 1: Execution failed , -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	'UPGRADE_NOTE: dir was upgraded to dir_Renamed. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Declare Function adt8840a_arc Lib "adt8840.dll" (ByVal devnum As Integer, ByVal dir_Renamed As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal i As Integer, ByVal j As Integer) As Integer
	'Function function: arc processing function'
	'Parameters: dev_num device number
	' dir 0: clockwise round 1: counterclockwise round
	'axis1 plane axis 1
	' axis2 plane axis 2
	'x, long y coordinates of arc end point, relative to the starting point
	'i, long j arc center coordinates, relative to the starting point for'
	'Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	' NOTE: The software arc processing mode by default enabled in the software cache under the conditions of implementation, you can implement a number of consecutive
	
	
	Declare Function adt8840a_pause Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	
	'Function function: motion to suspend and maintain the system for all state, including the drive status and speed values, etc.
	'
	'Parameters: int dev_num Equipment No.'
	'Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	Declare Function adt8840a_Resume Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Function function: to recover from the suspension to run'
	'Parameters: int dev_num Equipment No.'
	'Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	'//-------------------------------------------------//
	'//             Digital input output class                 //
	'//-------------------------------------------------//
	Declare Function adt8840a_read_bit Lib "adt8840.dll" (ByVal devnum As Integer, ByVal number As Integer, ByRef value As Integer) As Integer
	'Function: read input
	' parameters:
	'devnum device number
	' number input (0 - 49)
	'value 0: Low 1: High
	' Return value: 0: execution OK, 1: execution failed - 1: Send unusual, -2: response timeout -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_write_bit Lib "adt8840.dll" (ByVal devnum As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
	'Function: Output
	' Parameters: 'devnum device number
	' number output point (0 - 21)
	'value 0: Low 1: High
	' Return value: 0: execution OK, 1: Execution failed, -1: Send exception, -2: response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	
	Declare Function adt8840a_sudden_write_bit Lib "adt8840.dll" (ByVal devnum As Integer, ByVal number As Integer, ByVal value As Integer) As Integer
	'Function function: immediate write a single output point, the main mode for software cache operations into the output point response'
	'Parameters: int dev_num device number' number output dots (0-31)
	'value 0: low, 1: high '
	' Return value: 0: Send OK, -1: Send unusual, invalid device interface
	
	
	Declare Function adt8840a_read_8bit Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal ios As Integer, ByRef value As Integer) As Integer
	'Function function: 8 input points consecutive time'
	'Parameters: int dev_num device number
	' int ios start IO No.
	'int value state for 8 input points, corresponding to 0-7 bit'
	'Returns: 0: execution OK, 1 : execution failed -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	
	'**************************************************************************************/
	
	'//-------------------------------------------------//
	'//              Hardware cache                         //
	'//-------------------------------------------------//
	Declare Function adt8840a_fifo_inp_move1 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis1 As Integer, ByVal pulse1 As Integer, ByVal speed As Integer) As Integer
	'/************************** Uniaxial cache ******************* *******
	'function: single cache
	' parameter:
	'devnum device number
	' axis1 axis number (1 - 4)
	'pulse1 cache pulse
	' speed cache speed
	'return values: 0: execution OK, 1: fails, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface 'Description: A total of 2048 buffer space, each axis instruction cache space occupied by three can cache 682 instructions
	
	
	Declare Function adt8840a_fifo_inp_move2 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal speed As Integer) As Integer
	'Function: two-axle cache
	' parameter:
	'devnum device number
	' axis1 axis number (1 - 4)
	'axis2 axis number (1 - 4)
	' pulse1 cache pulses
	' pulse2 cache pulses
	' speed cache speed
	'return Value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface 'Description: A total of 2048 buffer space, each Axis occupy two cache directive Article 4 space, instruction cache 512
	
	Declare Function adt8840a_fifo_inp_move3 Lib "adt8840.dll" (ByVal devnum As Integer, ByVal axis1 As Integer, ByVal axis2 As Integer, ByVal axis3 As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal pulse3 As Integer, ByVal speed As Integer) As Integer
	'Function: axis cache
	' parameter:
	'devnum device number
	' axis1 axis number (1 - 4)
	'axis2 axis number (1 - 4)
	' axis3 axis number (1 - 4)
	'pulse1 cache pulses
	' pulse2 cache pulses
	' pulse3 cache pulses
	' speed cache speed
	'return values: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4 : Invalid Device Interface 'Description: A total of 2048 buffer space occupied by each axis 5 instruction cache space, cache 409 instructions
	
	
	Declare Function adt8840a_fifo_inp_move4 Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal pulse1 As Integer, ByVal pulse2 As Integer, ByVal pulse3 As Integer, ByVal pulse4 As Integer, ByVal speed As Integer) As Integer
	'Function: Four-axis cache
	' parameter:
	'devnum device number
	' axis1 axis number (1 - 4)
	'axis2 axis number (1 - 4)
	' axis3 axis number (1 - 4)
	'axis4 axis number (1 - 4)
	' pulse1 cache pulses
	' pulse2 cache pulses
	' pulse3 cache pulses
	' pulse4 cache pulses
	' speed cache speed
	'return values: 0: execution OK, 1: Execution failed, -1: Send unusual, -2 : Response timeout, -3: receive abnormal data, -4: Invalid Device Interface 'Description: A total of 2048 buffer space, each occupied by six four-axis instruction cache space, cache 341 instructions
	
	Declare Function adt8840a_reset_fifo Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Function: Clear cache
	' parameter:
	'devnum device number
	' return values: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: receive abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_read_fifo Lib "adt8840.dll" (ByVal devnum As Integer, ByRef value As Integer) As Integer
	'Function: read cache the number of orders placed into the left how many of the non-implementation
	' parameter:
	'devnum device number
	' value share of non-implementation of the instruction bytes
	' return values: 0: execution OK, 1: Execution failed , -1: send different
	Declare Function adt8840a_clear_buff_depth Lib "adt8840.dll" (ByVal dev_num As Integer) As Integer
	'Functions Function: Clear instruction cache
	' parameter: dev_num device number
	'return values: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	'//----------- --------------------------------------//
	'/ / system parameter type / /
	' / /------------------------------------------------- / /
	
	Declare Function adt8840a_FS_Remove Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal pFileName As String) As Integer
	'Function function: delete the file
	' parameter: int dev_num device number
	'char * pFileName file name
	' Return value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: received to the abnormal data, -4: Invalid Device Interface
	'////////////////////////////////////////////////////////////////
	Declare Function adt8840a_Net_Setup Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal IP As String, ByVal MASK As String, ByVal Gateway As String, ByVal MAC As String) As Integer
	'Function features: control card network configuration'
	'Parameters: dev_num device number' IP IP address
	'MASK subnet mask,' Gateway Gateway IP Address
	'MAC controller MAC address
	' return values: 0: execution OK, 1: Execution failed , -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_set_speed_mode Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal mode As Integer) As Integer
	'Function function: to set the speed mode'
	'Parameters: dev_num device number
	' mode 0: free mode, 1: fixed mode
	'only fixed mode settings on the file system parameter changes to be effective,'
	'Return value: 0: Send OK, - 1: Send unusual, -4: Invalid Device Interface
	'free mode: the system that users can run, through set_acc / set_startv / set_speed Zhi Ling at any time Genggai the axis
	' of the speed parameter, the system parameters without restrictions. In free mode, the user changes the system parameters can be downloaded to the control card,
	'and immediately effective parameters, but can not save the system parameter file.
	'Fixed mode: refers to the speed of each axis control card can only be used to set a good system of parameters of parameters, but also in the run-time can not be
	' set_acc / set_startv / set_speed command again to change, but the drive cache with hardware and G code, follow the instructions speed will continue to be effective.
	'In the fixed mode, the user to set the system parameters can be downloaded to the control card, and immediately effective parameters, while for the system parameter file is saved,
	' power-on reset when the system will automatically load the save of the system parameters.
	'Only a fixed model parameter settings on the file system changes to be effective
	
	Declare Function adt8840a_set_buff_mode Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal buffmode As Integer) As Integer
	'Function function: to set the software cache mode'
	'Parameters: dev_num device number
	' buffmode 0: Software cache off, 1: Software cache open '
	' Return value: 0: Send OK, -1: Send unusual, -4: Invalid device Interface
	
	Declare Function adt8840a_set_pulsemm Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal axis As Integer, ByVal PulseMm As Integer) As Integer
	'Functions Function: Set pulse equivalent'
	'Parameters: dev_num device number
	' axis axis No.
	'PulseMm pulse equivalent'
	'Return value: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	' Note: With this just as a way to set the parameters of the current operating parameters, are not saved to the file system control
	
	
	Declare Function adt8840a_get_pulsemm Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal axis As Integer, ByRef PulseMm As Integer) As Integer
	'Function features: access to pulse equivalent'
	'Parameters: dev_num device number
	' axis axis No. 1-4
	'PulseMm to receive the current axis pulse equivalent'
	'Returns: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	'UPGRADE_WARNING: Structure SYSPARA may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="C429C3A5-5D47-4CD9-8F51-74A1616405DC"'
	
	
	
	'UPGRADE_WARNING: Structure SYSPARA may require marshalling attributes to be passed as an argument in this Declare statement. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="C429C3A5-5D47-4CD9-8F51-74A1616405DC"'
	
	
	Declare Function adt8840a_wait_delay Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal delay As Integer) As Integer
	'Functions Function: Delay wait'
	'Parameters: dev_num device number
	' delay delay waiting time, unit: ms
	'Return value: 0: execution OK, -1: Send unusual, -4: Invalid Device Interface
	' NOTE: The cache mode in the software implementation schedule
	'
	Declare Function adt8840a_wait_inport_l Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal inport As Integer) As Integer
	'Function function: to wait for the input signal'
	'Parameters: dev_num device number
	' inport waiting for input signal, active low
	'return values: 0: execution OK, -1: Send unusual, -4: Invalid Device Interface
	' Note: Cache mode used for scheduling software implementation Declare Function adt8840a_wait_inport_h Lib "adt8840.dll" (ByVal dev_num As Long, ByVal inport As Long) As Long
	'function function: wait input signal'
	'Parameters: dev_num device number
	' inport wait input signal, active low
	'return values: 0: execution OK, -1: Send unusual, -4: invalid device interface
	' NOTE: The cache mode for the software implementation schedule
	
	'**************************************************************************************/
	'**************************************************************************************/
	
	'//-------------------------------------------------//
	'//                 GCode Processing
	
	'//-------------------------------------------------//
	Declare Function adt8840a_get_sys_status Lib "adt8840.dll" (ByVal dev_num As Integer, ByRef idle As Integer, ByRef g_status As Integer, ByRef lock_stop As Integer) As Integer
	'Function function: query control card status, including the driver state, G code processing condition
	'
	'Parameters: dev_num device number
	' idle status information access system driver, 0 for idle, 1 for drive
	'G_status get G code processing status, 0: G code processing is not started, 1: G code processing carried out in the
	'lock_stop get emergency stop self-locking state, 0 normal, 1 for the emergency stop self-lock status'
	' Note: When G code activates the G code in the tail, using M0 / M1/M0 instruction or use the trip to the G code to identify features removed.
	'When using adt8840a_stop_all or external emergency stop signal to trigger the trip event, the control card will be in a state of self-locking 500 ms, and the output port OUT0 high pulse'
	'Returns: 0: execution OK, 1: execution failed -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_download_gfile Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Function function: the G code program to the control card in the
	' Parameters: dev_num device number
	'return values: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	'UPGRADE_NOTE: err was upgraded to err_Renamed. Click for more: 'ms-help://MS.VSCC.v90/dv_commoner/local/redirect.htm?keyword="A9E4979A-37FA-4718-9994-97DD76ED70A7"'
	Declare Function adt8840a_upload_gfile Lib "adt8840.dll" (ByVal devnum As Integer, ByRef length As Integer, ByRef err_Renamed As Integer) As Integer
	'Function function: to open and access control card in the G-code program file'
	'Parameters: dev_num device number
	' length G code program length
	'err 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Answer timeout -3: received abnormal data, -4: Invalid Device Interface '
	' Return Value: g_code G code program
	
	
	Declare Sub adt8840a_copy_data Lib "adt8840.dll" (ByVal data As String, ByVal soure As Integer, ByVal data_len As Integer)
	'Function: Copies Control card G-code program'
	'Parameters: data G code program
	' soure G code program address from adt8840a_upload_gfile function returns
	' length G code program length
	'Returns: None
	' Note: This function only in VB be used for reading adt8840a_upload_gfile () function returns the memory data, and release the data in the copy of the DLL.
	
	Declare Function adt8840a_g_code Lib "adt8840.dll" (ByVal devnum As Integer, ByVal g_code As String) As Integer
	'Function function: a single implementation of the G code command'
	'Parameters: dev_num device number
	' G_code G code command string
	'Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_ram_pre Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Function features: pretreatment control card memory G-code program, this function is used to record G code subroutine entry address in the adt8840a_download_gcode () function after the use of
	' non-routine structures such as the G code without using the function
	'parameters: int dev_num device number
	'return values: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	Declare Function adt8840a_run_gfile Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Functions Function: ready to start the G code file processing, pretreatment control card ROM in the G code program'
	'Parameters: dev_num Equipment No.'
	'Returns: 0: Send OK, -1: Send unusual, -4: Invalid device Interface
	
	Declare Function adt8840a_get_gcode_depth Lib "adt8840.dll" (ByVal dev_num As Integer, ByRef buff_depth As Integer, ByVal gcode As String) As Integer
	'Function function: G code online for download processing, the control card is used to check the G already received instruction cache depth and current instruction being executed G'
	'Parameters: dev_num Equipment No.
	'
	'output parameter buff_depth to receive inquiries to G-depth instruction cache, the cache depth should not exceed 127, (0-127),
	'gcode output parameter to receive instruction currently being executed G
	'
	'Returns: 0: execution OK, 1: to fail, -1 : Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	Declare Function adt8840a_download_gcode Lib "adt8840.dll" (ByVal dev_num As Integer, ByVal g_code As String, ByVal code_len As Integer) As Integer
	'Function function: the G code program to download the form of data blocks to the control card memory
	'
	'Parameters: dev_num device number
	' g_code G code data address
	' code_len G code block length bytes, the size can not exceed 512 * 1024 = 524288 (Byte)
	'
	' Return value: 0: execution OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	
	
	Declare Function adt8840a_run_gcode Lib "adt8840.dll" (ByVal devnum As Integer) As Integer
	'Function function: start G code processing, G code to the form of data blocks in the controller RAM,
	'
	'Parameters: int dev_num Equipment No.
	'
	'Returns: 0: Send OK, -1: Send unusual, -4: Invalid Device Interface
	
	Declare Function adt8840a_buff_block_status Lib "adt8840.dll" (ByVal devnum As Integer, ByRef status As Integer) As Integer
	'Function function: in the form of a data block download G code, check control card in the instruction cache block states
	'
	' Parameters: dev_num device number
	'status memory idle state, 0 for idle, 1 for busy
	' return values: 0: implementation of the OK, 1: Execution failed, -1: Send unusual, -2: Response timeout, -3: received abnormal data, -4: Invalid Device Interface
	Declare Sub adt8840a_dll_free Lib "adt8840.dll" (ByRef data As Integer)
	'Function function: release memory allocated in DLL, the memory address by the adt8840a_upload_gfile () function returns
	'
	'Parameters: data data pointer
	' 'Returns: None
	' Note: This function can only repeat the call to open the G file
	
	'**************************************************************************************
	
	Public Sub MyProc()
		
		System.Windows.Forms.Application.DoEvents()
		
	End Sub
End Module